program p_7_4;

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////}
uses crt, graf_fx;

{// S T A L E
{///////////////////////////////////////}

const tab_mapy : array[0..11,0..18] of byte =
(
(10, 10, 10,  3,  6,  1,  3,  0,  9, 8,  4, 10,  3,  5,  8,  8,  7,  6,  6),
( 9,  8,  8,  4,  3,  0,  2,  6,  5, 8,  8,  8,  4, 13,  8, 12,  2,  6,  6),
( 0, 11,  9,  8,  7,  6,  1, 10, 13, 8,  8,  8,  8,  8, 12,  2,  6,  6,  1),
( 6,  6,  0,  9,  4, 10, 13,  8,  8, 8,  8,  8, 12,  9,  7,  6,  6,  6,  5),
( 6,  6,  6,  5,  8,  8,  8,  8,  8, 8,  8,  8,  4, 13,  4, 10, 10,  3,  0),
( 1, 10, 10, 13,  8,  8, 12,  9,  8, 8,  8,  8,  8,  8,  8,  8,  8,  4,  3),
( 0,  9,  8,  8,  8,  8,  4, 13,  8, 8,  8, 12, 11, 11,  9,  8,  8,  8,  4),
( 1, 13,  8,  8, 12,  9,  8,  8,  8, 8, 12,  2,  6,  6,  5,  8,  8,  8,  8),
(13,  8, 12, 11,  2,  0,  9,  8, 12, 9,  4,  3,  6,  1, 13,  8,  8,  8, 12),
( 8,  8,  4, 10,  3,  1, 13,  8,  7, 0,  9,  4, 10, 13,  8,  8, 12, 11,  2),
(12,  9,  8,  8,  4, 13,  8,  8,  4, 3,  0, 11,  9,  8, 12, 11,  2,  6,  6),
( 4, 13,  8,  8,  8,  8,  8,  8,  8, 4,  6,  6,  0,  8,  7,  6,  6,  6,  6)
);

{// Z M I E N N E   G L O B A L N E
{///////////////////////////////////////}
var
docelowy, zrodlowy : prostokat;
grafika : obraz;
adres_2_bufora : pointer;
czy_program_dziala : boolean;
lewy, srodkowy, prawy : boolean;
mysz_poz_x, mysz_poz_y : word;
mapa_poz_x, mapa_poz_y : word;

{//  P R O C E D U R Y
{///////////////////////////////////////}

procedure wyswietl_gorna_i_boczna_listwe;
begin

{wyswietlenie gornej listwy}
g_wypelnij_p(zrodlowy, 0, 170, 320, 30);
g_wypelnij_p(docelowy, 0, 0, 320, 30);

g_wyswietl_obraz_13h(adres_2_bufora, zrodlowy, docelowy, grafika);

{wyswietlenie bocznej listwy}
g_wypelnij_p(zrodlowy, 250, 0, 70, 170);
g_wypelnij_p(docelowy, 250, 30, 70, 170);

g_wyswietl_obraz_13h(adres_2_bufora, zrodlowy, docelowy, grafika);

end; {koniec procedury wyswietl_gorna_i_boczna_listwe}

{--------------}

procedure wyswietl_kursor;
begin

{pobranie aktualnego stanu myszy}
g_pobierz_status_myszy(lewy, srodkowy, prawy, mysz_poz_x, mysz_poz_y);

g_wypelnij_p(zrodlowy, 201, 101, 9, 9);
g_wypelnij_p(docelowy, mysz_poz_x div 2, mysz_poz_y, 9, 9);

g_wyswietl_obraz_13h_k(adres_2_bufora, zrodlowy, docelowy, grafika,
                       TRUE, grafika.wsk_obrazu^[(320*100)+200]);

{przesuniecie mapy w poziomie}
if((mysz_poz_x div 2) = 0) then if(mapa_poz_x > 0 ) then dec(mapa_poz_x);
if((mysz_poz_x div 2) = 319) then if(mapa_poz_x < 14 ) then inc(mapa_poz_x);

{przesuniecie mapy w pionie}
if(mysz_poz_y = 0) then if(mapa_poz_y > 0 ) then dec(mapa_poz_y);
if(mysz_poz_y = 199) then if(mapa_poz_y < 8) then inc(mapa_poz_y);

end; {koniec procedury wyswietl_kursor}

{--------------}

procedure wyswietl_mape;
var
licznik_x, licznik_y : byte;
begin

for licznik_y := 0 to 3 do
for licznik_x := 0 to 4 do
begin

g_wypelnij_p(zrodlowy,
             (tab_mapy[mapa_poz_y + licznik_y,
                       mapa_poz_x + licznik_x] mod 5) * 50,
             (tab_mapy[mapa_poz_y + licznik_y,
                       mapa_poz_x + licznik_x] div 5) * 50,
             50, 50
            );

g_wypelnij_p(docelowy,
             licznik_x * 50,
             (licznik_y * 50) + 30,
             50, 50
            );

g_wyswietl_obraz_13h(adres_2_bufora, zrodlowy, docelowy, grafika);

end; {koniec petli for licznik_y}

end; {koniec procedury wyswietl_mape}

{// G L O W N Y   P R O G R A M
{///////////////////////////////////////}

begin
{inicjalizacja zmiennych}
czy_program_dziala := TRUE;
mapa_poz_x := 0;
mapa_poz_y := 0;

{wlanczamy tryb graficzny 320x200x256}
g_ustaw_tryb_vga($13);

{zaladowanie calej grafiki}
g_laduj_BMP_13h(grafika, 'grafika.bmp');

{zaladowanie palety kolorow}
g_laduj_palete_BMP('grafika.bmp');

{pobranie pamieci dla drugiego buforaw wideo i jego adresu}
g_pobierz_pam_dla_drugiego_bufora(adres_2_bufora);

{petla wykonuje sie do momentu nacisniecia dowolnego klawisza}
while (czy_program_dziala) do
begin

wyswietl_gorna_i_boczna_listwe;
wyswietl_mape;
wyswietl_kursor;

{jezeli nacinieto dowolny klawisz to ustawiamy zmienna czy_program_dziala
 na FALSE, co wywoluje przerwanie petli while do}
if(keypressed) then czy_program_dziala := FALSE;

{czkamy na powrot pionowy poczym kopiujemy zawartosc drugiego
 bufora wideo do pierwszego bufora}
g_czekaj_na_powrot_pionowy;
g_kopiuj_bufor(ptr($A000,0000), adres_2_bufora);

{opoznienie}
delay(80);
end; {koniec petli while do}

{zwolnienie pamieci przydzielonej pod obrazy i drugi bufor wideo}
g_zwolnij_pam(grafika);
g_zwolnij_pam_bufora(adres_2_bufora);

end. {koniec programu}